Option Strict Off
Option Explicit On
Module APITesting
	Public szTestString As New VB6.FixedLengthString(255)
	Public Sub ArrayTest()
        Dim y As Long
        Dim x As Long
		
		Dim bBoolResult As Boolean
		Dim dValue As Double
		Dim dReal As Double
		Dim dImag As Double
		
		Dim dNumArray(3, 4) As Double
		Dim dRealArray(4, 5, 6, 7, 8) As Double
		Dim dImagArray(4, 5, 6, 7, 8) As Double

        lzShowInfoBox()

		bBoolResult = lzClearContext()
        'lzSetInvertArrayIndices((True))
		
		bBoolResult = lzCreatePrivateContext("API Test")
		bBoolResult = lzSetContext("API Test", False)
		
		For x = 0 To 3
			For y = 0 To 4
                dNumArray(x, y) = x + y / 10
			Next y
		Next x
		
		bBoolResult = lzLinkNumArray(kGlobalScope, "dNumericArray", dNumArray(0, 0), 2, 4, 5, 0, 0, 0, 0)
		
		For x = 0 To 3
			For y = 0 To 4
				
                dValue = lzGetNumArrayElement(kGlobalScope, "dNumericArray", 2, x, y, 0, 0, 0, 0)
				
			Next y
		Next x
		
		bBoolResult = lzSetNumArrayElement(kGlobalScope, "dNumericArray", 88, 2, 2, 3, 0, 0, 0, 0)
		
		bBoolResult = lzLinkComplexArray(kGlobalScope, "dComplexArray", dRealArray(0, 0, 0, 0, 0), dImagArray(0, 0, 0, 0, 0), 5, 5, 6, 7, 8, 9, 0)
		
		dRealArray(3, 4, 5, 6, 7) = 9.13
		dImagArray(3, 4, 5, 6, 7) = 5.1
		
		bBoolResult = lzGetComplexArrayElement(kGlobalScope, "dComplexArray", dReal, dImag, 5, 3, 4, 5, 6, 7, 0)
		
		bBoolResult = lzSetRealArrayElement(kGlobalScope, "dComplexArray", 36, 5, 3, 4, 5, 6, 7, 0)
		
		bBoolResult = lzSetImagArrayElement(kGlobalScope, "dComplexArray", 42, 5, 3, 4, 5, 6, 7, 0)
		
		bBoolResult = lzGetComplexArrayElement(kGlobalScope, "dComplexArray", dReal, dImag, 5, 3, 4, 5, 6, 7, 0)
		
		bBoolResult = lzDestroyPrivateContext("API Test")
		bBoolResult = lzSetContext("VBTest", False)
		
	End Sub
	Public Sub VarTest()
        Dim dResult As Double
		
		Dim bBoolResult As Boolean
		Dim dValue As Double
		Dim dReal As Double
		Dim dImag As Double
		Dim szString As String
		
		Dim dLinkValue As Double
		Dim dLinkReal As Double
		Dim dLinkImag As Double
		Dim szLinkString As New VB6.FixedLengthString(1024)
		
		Dim lResult As Integer
		Dim szResult As String
		
		Dim bIsVarResult As Boolean
		Dim cVarType As Byte
		
		bBoolResult = lzClearContext()
		lzSetInvertArrayIndices((True))
		
		bBoolResult = lzCreatePrivateContext("API Test")
		bBoolResult = lzSetContext("API Test", False)
		
		dValue = 31.6
		dReal = 14.4
		dImag = 42.7
		
		szString = New String(vbNullChar, 255)
		
		bBoolResult = lzSetNumVar(kGlobalScope, "dValue", 123)
		bBoolResult = lzSetComplexVar(kGlobalScope, "dComplex", 456, 789)
		bBoolResult = lzSetRealVar(kGlobalScope, "dComplex", 456)
		bBoolResult = lzSetImagVar(kGlobalScope, "dComplex", 789)
		
		bBoolResult = lzCreateStrVar(kGlobalScope, "szString", 256)
		bBoolResult = lzSetStrVar(kGlobalScope, "szString", "Mithril")
		
        dResult = lzGetNumVarValue(kGlobalScope, "dValue")
		bBoolResult = lzGetComplexVarValue(kGlobalScope, "dComplex", dReal, dImag)
		szString = lzGetStrVarValue(kGlobalScope, "szString")
		
		lResult = lzDeleteVar(kGlobalScope, "dValue")
        dResult = lzGetNumVarValue(kGlobalScope, "dValue")
		
		dLinkValue = 731.6
		dLinkReal = 814.4
		dLinkImag = 942.7
		
		bBoolResult = lzLinkComplexVar(kGlobalScope, "dLinkComplex", dLinkReal, dLinkImag)
		bBoolResult = lzSetComplexVar(kGlobalScope, "dLinkComplex", 456.7, 789.1)
		
		bBoolResult = lzLinkNumVar(kGlobalScope, "dLinkValue", dLinkValue)
		bBoolResult = lzSetNumVar(kGlobalScope, "dLinkValue", 432.1)
		
		'szLinkString = String(20, vbNullChar)
		szLinkString.Value = "Holy wazoo, Batman!"
		
		bBoolResult = lzCreateNumArray(kGlobalScope, "dRealArray", 2, 4, 4, 0, 0, 0, 0)
		bBoolResult = lzSetNumArrayElement(kGlobalScope, "dRealArray", 1.2, 2, 2, 3, 0, 0, 0, 0)
		dReal = lzGetNumArrayElement(kGlobalScope, "dRealArray", 2, 1, 1, 0, 0, 0, 0)
		dReal = lzGetNumArrayElement(kGlobalScope, "dRealArray", 2, 2, 3, 0, 0, 0, 0)
		
		bBoolResult = lzCreateComplexArray(kGlobalScope, "dComplexArray", 2, 4, 4, 0, 0, 0, 0)
		bBoolResult = lzSetComplexArrayElement(kGlobalScope, "dComplexArray", 2, 1.2, 2, 2, 3, 0, 0, 0, 0)
		bBoolResult = lzGetComplexArrayElement(kGlobalScope, "dComplexArray", dReal, dImag, 2, 1, 1, 0, 0, 0, 0)
		bBoolResult = lzGetComplexArrayElement(kGlobalScope, "dComplexArray", dReal, dImag, 2, 2, 3, 0, 0, 0, 0)
		
		bBoolResult = lzCreateStrArray(kGlobalScope, "szStrArray", 128, 2, 16, 16, 0, 0, 0, 0)
		bIsVarResult = lzIsVar(kGlobalScope, "szStrArray")
		bIsVarResult = lzIsOp(kGlobalScope, "szStrArray")
		bIsVarResult = lzIsSymbol(kGlobalScope, "szStrArray")
		
		cVarType = lzGetVarType(kGlobalScope, "szStrArray")
		bBoolResult = lzSetStrArrayElement(kGlobalScope, "szStrArray", "Get the super sauce, Fred!", 2, 3, 4, 0, 0, 0, 0)
		szResult = lzGetStrArrayElement(kGlobalScope, "szStrArray", 2, 3, 4, 0, 0, 0, 0)
		
		bIsVarResult = lzIsVar(kGlobalScope, "szLinkString")
		cVarType = lzGetVarType(kGlobalScope, "szLinkString")
		
		bIsVarResult = lzIsVar(kGlobalScope, "dLinkComplex")
		cVarType = lzGetVarType(kGlobalScope, "dLinkComplex")
		
		szResult = lzEvalExpStrToStr("szLinkString")
		szResult = szLinkString.Value
		
		bBoolResult = lzDestroyPrivateContext("API Test")
		bBoolResult = lzSetContext("VBTest", False)
		
	End Sub
	Public Sub HandleError(ByRef lErrorNumber As Integer)
		Dim errorText As String
		Dim lastError As Integer
		
		errorText = lzGetLastErrorText()
		lastError = lzGetLastErrorID()
		MsgBox(errorText)
	End Sub
	Public Function MyExtOperator(ByVal lLinkID As Integer) As Integer
		Dim x As Double
		Dim y As String
		Dim z As Boolean
        Dim callResult As Integer
		Dim count As Integer
		Dim parmType As Byte
		Dim parmSig As String
		
		parmSig = lzGetParmSig(lLinkID)
		count = lzGetParmCount(lLinkID)
		parmType = lzGetParmType(lLinkID, 0)
		parmType = lzGetParmType(lLinkID, 1)
		parmType = lzGetParmType(lLinkID, 2)
		
		x = lzGetNumParm(lLinkID, 0)
		y = lzGetStrParm(lLinkID, 1)
		z = lzGetBoolParm(lLinkID, 2)
		
		If (z = True) Then
			callResult = lzSetBoolResult(lLinkID, True)
		Else
			callResult = lzSetBoolResult(lLinkID, False)
		End If
		
		MyExtOperator = 0
	End Function
	Public Function MyOtherExtOperator(ByVal lLinkID As Integer) As Integer
		Dim x As Double
        Dim result As Double
		Dim callResult As Integer
		Dim count As Integer
		Dim parmType As Byte
		Dim parmIndex As Integer
		Dim parmSig As String
		
		parmSig = lzGetParmSig(lLinkID)
		
		count = lzGetParmCount(lLinkID)
		
		For parmIndex = 0 To count - 1
			parmType = lzGetParmType(lLinkID, parmIndex)
			If parmType = kTypeNum Then
				x = lzGetNumParm(lLinkID, parmIndex)
				result = result + x
			End If
		Next parmIndex
		
		callResult = lzSetNumResult(lLinkID, result)
		
		MyOtherExtOperator = 0
	End Function
End Module